﻿using System;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.Collections;
using System.Drawing;
using System.Linq;
using System.Workflow.ComponentModel.Compiler;
using System.Workflow.ComponentModel.Serialization;
using System.Workflow.ComponentModel;
using System.Workflow.ComponentModel.Design;
using System.Workflow.Runtime;
using System.Workflow.Activities;
using System.Workflow.Activities.Rules;
using System.Threading;
using System.Collections.Generic;



/*  
    ReplicatorActivity conditional activity class    

    This example, in the Replicator_Initialized() event handler, assigns a list of Job objects to 
    the InitialChildData property of a ReplicatorActivity  and sets the
    ExecutionType property to process those Job objects either in parallel
    or in sequence (check the relevant comment).
 
    The Replicator_Completed() event handler is executed when the replicator finishes.
    
    The Replicator_ChildInitialized() and the Replicator_ChildCompleted event handlers
    are executed when a Job starts or finishes execution. 
   
    The actual execution of a Job is done by the actProcessJob_ExecuteCode() event handler linked to the 
    actProcessJob.ExecuteCode event. The code of this event handler extracts Job objects, as     
        Job job = (Job)replicator.CurrentChildData[replicator.CurrentIndex];
    and then calls 
        job.Execute();
 
    CurrentChildData is an IList object and it is the Job list passed initially. The CurrentIndex
    is an int denoting the current iteration.
 */
namespace Lessons.Workflows
{
	public sealed partial class Workflow1: SequentialWorkflowActivity
	{
		public Workflow1()
		{
			InitializeComponent();
		}

         


        private void Replicator_Initialized(object sender, EventArgs e)
        {
            List<Job> jobs = new List<Job>();

            Random random = new Random();
            int jobCount = random.Next(3, 10);

            for (int i = 0; i < jobCount; i++)
                jobs.Add(new Job());


            ReplicatorActivity replicator = sender as ReplicatorActivity;

            replicator.InitialChildData = jobs;
            replicator.ExecutionType = ExecutionType.Parallel;  // Sequence Parallel
        }


        void Replicator_ChildInitialized(object sender, ReplicatorChildEventArgs e)
        {
            Job job = (Job)e.InstanceData;
            Console.WriteLine(string.Format("{0}: Job [{1}] started", e.Activity.Name, job.ID));
        }

        void Replicator_ChildCompleted(object sender, ReplicatorChildEventArgs e)
        {
            Job job = (Job)e.InstanceData;
            Console.WriteLine(string.Format("{0}: Job [{1}] completed ", e.Activity.Name, job.ID));
        }

        void Replicator_Completed(object sender, EventArgs e)
        {
            Console.WriteLine("Workflow done");
        }

        void Replicator_UntilCondition(object sender, ConditionalEventArgs e)
        {
            ReplicatorActivity replicator = sender as ReplicatorActivity;
            e.Result = replicator.AllChildrenComplete; 
        }

        private void actProcessJob_ExecuteCode(object sender, EventArgs e)
        {
            Activity a = sender as Activity;
            ReplicatorActivity replicator = a.Parent as ReplicatorActivity;
            Job job = (Job)replicator.CurrentChildData[replicator.CurrentIndex];
                        
            job.Execute();
        } 


	}




    public class Job
    {
        static private Random random = new Random();
        static private int counter = 0;

        public int ID = counter++;

        public void Execute()
        {
            int i = random.Next(5, 12);
            while (i > 0)
            {
                i--;
                Thread.Sleep(100);
            }
        }
    }



}







 







 